\name{envelope}

\alias{envelope}

\title{Isotope pattern envelope calculation}

\description{
Convolutes an isotope pattern from \code{\link[enviPat]{isopattern}} with a peak shape function (Gaussian or Cauchy-Lorentz function) 
to its theoretical envelope (profile), at a given measurement resolution. 
The envelope is represented by sticks, i.e. measurement abundances at discrete m/z intervals. 
}

\usage{envelope(pattern, ppm = FALSE, dmz = "get", frac = 1/4, env = "Gaussian", 
resolution = 5e+05, plotit = FALSE)}


\arguments{

  \item{pattern}{List of isotope pattern(s) as generated by \code{\link[enviPat]{isopattern}}.}

  \item{ppm}{Should stick discretization be set in ppm (\code{TRUE}) or absolute m/z (\code{FALSE})?
	Only checked if \code{dmz} is not set to \code{"get"}; check details section.}

  \item{dmz}{Stick discretization. Set to \code{"get"} to derive discretization from argument \code{resolution} or set a numerical value
	in combination with \code{ppm} to use as ppm or absolute m/z. Check details section.}

  \item{frac}{Used if \code{dmz} is set to \code{"get"}. Check details section.}

  \item{env}{Peak shape function; either \code{"Gaussian"} or \code{"CauchyLorentz"}.}

  \item{resolution}{Single resolution value or vector of resolutions with length equal to the number of entries in list \code{pattern}. 
	Check resolution definition in the details section.}

  \item{plotit}{Should results be plotted, \code{TRUE/FALSE} ?}

}


\details{
The theoretical profiles are represented by sticks, i.e. abundances at discrete m/z intervals.
While the profile width is set by argument \code{resolution}, the mass discretization between adjacent sticks can be set in two different ways. 

On the one hand, discretization can be given as a numerical value, either in ppm or absolute m/z. 
To do so, set argument \code{dmz} to a numerical value and specify with argument \code{ppm} if this value is stating the discretization in ppm or 
as absolute m/z.

On the other hand, discretization can be derived from the measurement resolution (R) set by
argument \code{resolution}. To do so, set \code{dmz} to \code{"get"}, which leads to argument \code{ppm} being ignored. 
In this case, the stick discretization is retrieved from (dm/z)*\code{frac}, with (dm/z) = (m/z)/R = peak width at half maximum.}

\value{
List with length equal to length of list \code{pattern}, with equal names of list entries.
Each entry in that list contains the sticks of the envelope in two columns:
\item{m/z}{Stick m/z}
\item{abundance}{Stick abundance}
}

\seealso{
	\code{\link[enviPat]{isopattern}}
	\code{\link[enviPat]{getR}}
	\code{\link[enviPat]{vdetect}}
}


\references{
Li, L., Kresh, J., Karabacak, N., Cobb, J., Agar, J. and Hong, P. (2008). 
A Hierarchical Algorithm for Calculating the Isotopic Fine Structures of Molecules.
Journal of the American Society for Mass Spectrometry, 19, 1867--1874.
}

\author{Martin Loos, Christian Gerber}

\note{The resolution R is defined as R=(m/z)/(dm/z), with dm/z = peak width at half maximum, cp. \code{\link[enviPat]{resolution_list}}.}

\examples{

############################
# batch of chemforms #######
data(isotopes)
data(chemforms)

pattern<-isopattern(
  isotopes,
  chemforms,
  threshold=0.1,
  plotit=TRUE,
  charge=FALSE,
  emass=0.00054858,
  algo=2
)

profiles<-envelope(
    pattern,
    ppm=FALSE,
    dmz=0.0001,   
    frac=1/4,
    env="Gaussian",
    resolution=1E6,
    plotit=TRUE
)
############################

}
