\name{prcp}
\alias{prcp}
\alias{prcpFit}
\title{
  Precipitation Data Set
}
\description{
 This is a subset of daily 48 hour forecasts of 24 hour accumulated 
 precipitation over the US Pacific Northwest region in 2003-2004 based 
 on the 9 member University of Washington mesoscale ensemble
(Grimit and Mass 2002; Eckel and Mass 2005). \cr
Note that forecasts are not available for some of the interim dates.
}
\format{
A data frame with 175 rows and 15 columns: \cr
CENT        - forecasts from the CENT member of the ensemble (numeric). \cr
AVN         - forecasts from the AVN member of the ensemble (numeric). \cr
CMCG        - forecasts from the CMCG member of the ensemble (numeric). \cr
ETA         - forecasts from the ETA member of the ensemble (numeric). \cr
GASP        - forecasts from the GASP member of the ensemble (numeric). \cr
JMA         - forecasts from the JMA member of the ensemble (numeric). \cr
NGAPS       - forecasts from the NGAPS member of the ensemble (numeric). \cr
TCWB        - forecasts from the TCWB member of the ensemble (numeric). \cr
UKMO        - forecasts from the UKMO member of the ensemble (numeric). \cr
observation - the observed sea-level pressure (numeric). \cr
date        - the date of each forecast/observation set, \cr
		in the format YYYYMMDDHH (categorical). \cr
station     - weather station identifier (categorical). \cr
latitude    - the latitude of each weather station (numeric). \cr
longitude   - the longitude of each weather station (numeric). \cr
elevation   - the elevation of each weather station (numeric). 
}

\details{
This dataset is a small subset of the data used in Sloughter et al. (2006),
provided for the purposes of testing. Typically forecasting would be
performed on much larger datasets.
}

\references{
E. P. Grimit and C. F. Mass, 
Initial results of a mesoscle short-range ensemble forecasting system over
the Pacific Northwest, 
\emph{Weather and Forecasting 17:192--205, 2002}.

F. A. Eckel and C. F. Mass, 
Effective mesoscle, short-range ensemble forecasting,
\emph{Weather and Forecasting 20:328--350, 2005}.

J. M. Sloughter, A. E. Raftery, T. Gneiting and C. Fraley, 
Probabilistic Quantitative Precipitation Forecasting 
using Bayesian Model Averaging,
Technical Report No. 496R, Department of Statistics, University of
Washington, October 2006 (to appear in \emph{Montly Weather Review}).
}

\examples{
\dontrun{
  data(prcp)

  prcpData <- ensembleData( dates = prcp$date, observations = prcp$obs,
                          forecasts = prcp[,c("CENT","AVN","CMCG","ETA",
                                      "GASP","JMA","NGPS","TCWB","UKMO")])
  prcpFit <- ensembleBMA(prcpData, model = "gamma0")
}
}
\keyword{data}
% docclass is function
