% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche_signal.R
\name{niche_signal}
\alias{niche_signal}
\alias{niche_signal_univariate}
\alias{niche_signal_permanova}
\title{Niche Signal detection using one or multiple variables}
\usage{
niche_signal(data, condition, variables, method = "univariate",
             permanova_method = "mahalanobis", iterations = 1000,
             set_seed = 1, verbose = TRUE, ...)

niche_signal_univariate(data, condition, variable, iterations = 1000,
                        set_seed = 1, verbose = TRUE)

niche_signal_permanova(data, condition, variables, permutations = 999,
                       permanova_method = "mahalanobis", verbose = TRUE, ...)
}
\arguments{
\item{data}{matrix or data.frame containing at least the following
information: a column representing \code{condition} (positive = 1 or
negative = 0), and one or more columns representing environmental variables.}

\item{condition}{(character) name of the column with numeric information
about detection (positive = 1 or negative = 0).}

\item{variables}{(character) vector of one or more names of columns to be
used as environmental variables. If \code{method} = "univariate", only one
variable is used; for \code{method} = "permanova", multiple variables can
be used.}

\item{method}{(character) name of the method to be used for niche comparison.
Default = "univariate".}

\item{permanova_method}{(character) name of the dissimilarity index to be
used as \code{method} in \code{\link[vegan]{adonis2}}. See all options in
\code{\link[vegan]{vegdist}}. Default = "mahalanobis".}

\item{iterations}{(numeric) number of iterations to be used in analysis.
Default = 1000. If \code{method} = "permanova", permutations = iterations - 1.}

\item{set_seed}{(numeric) integer value to specify a initial seed.
Default = 1.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}

\item{...}{other arguments to be passed to \code{\link[vegan]{adonis2}}.}

\item{variable}{(character) name of the column containing data to be used
as environmental variable.}

\item{permutations}{number of permutations to be performed.}
}
\value{
A list with results from analysis depending on \code{method}.
}
\description{
Identifies whether a signal of niche can be detected using one or multiple
variables. This is an implementation of the methods developed by
Cobos & Peterson (2022) \url{doi:10.17161/bi.v17i.15985} that
focuses on identifying niche signals in presence-absence data.
}
\examples{
# Load species occurrences and environmental data.
data("enm_data", package = "enmpa")
head(enm_data)

# Detection of niche signal using an univariate non-parametric test
sn_bio1 <- niche_signal(data = enm_data, variables = "bio_1",
                        condition = "Sp", method = "univariate")
sn_bio1

sn_bio12 <- niche_signal(data = enm_data, variables = "bio_12",
                         condition = "Sp", method = "univariate")
sn_bio12
}
