% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energylossbeta.R
\name{energylossbeta}
\alias{energylossbeta}
\title{Energy Loss Calculation with Beta Scaling}
\usage{
energylossbeta(yt, mxt, mxpt, beta)
}
\arguments{
\item{yt}{A tensor representing the target values.}

\item{mxt}{A tensor representing the model's stochastic predictions.}

\item{mxpt}{A tensor representing another draw of the model's stochastic predictions.}

\item{beta}{A numeric value for scaling the energy loss.}
}
\value{
A scalar representing the calculated energy loss.
}
\description{
This function calculates the energy loss for given tensors. The loss is calculated
as the mean of the L2 norms between \code{yt} and \code{mxt} and between \code{yt} and \code{mxpt},
each raised to the power of \code{beta}, subtracted by half the mean of the L2 norm between \code{mxt} and \code{mxpt},
also raised to the power of \code{beta}.
}
\keyword{internal}
