% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRemoveAttributeDefinitions}
\alias{AddListRemoveAttributeDefinitions}
\alias{add_attributeDefinition}
\alias{list_attributeDefinitions}
\alias{remove_attributeDefinition}
\title{Add / List / Remove attribute definition to / of / from emuDB}
\usage{
add_attributeDefinition(emuDBhandle, levelName, name, type = "STRING")

list_attributeDefinitions(emuDBhandle, levelName)

remove_attributeDefinition(emuDBhandle, levelName, name)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{levelName}{name of level}

\item{name}{name of attributeDefinition}

\item{type}{type of attributeDefinition (currently only "STRING")}
}
\description{
Add / List / Remove database operation functions for attribute definition 
to / of / from an existing level definition
of a emuDB. Attribute
definitions can be viewed as definitions of
parallel labels for the annotational units (ITEMs) of the emuDB. 
Each level definition is required to have at least one 
default attribute definition that has the same name as the level definition
(automatically created by \code{\link{add_levelDefinition}}). For more 
information on the structural elements of an emuDB see \code{vignette(emuDB)}.
Note that as with level definitions, an attribute definition to a level cannot be removed,
if it contains labels in the emuDB.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# add additional attribute definition to the "Phonetic" level
# of the ae emuDB that will contain the UTF8 IPA
# symbols of the phonetic transcriptions
add_attributeDefinition(emuDBhandle = ae,
                        levelName = "Phonetic",
                        name = "IPA-UTF8")
                        
# list attribute definitions for level "Word"
# of the ae emuDB
list_attributeDefinitions(emuDBhandle = ae, 
                          levelName = "Word")

# remove newly added attributeDefinition
remove_attributeDefinition(emuDBhandle = ae,
                           levelName = "Phonetic",
                           name = "IPA-UTF8")
}

}
\keyword{DBconfig}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}

