% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.R
\name{create_emuDB}
\alias{create_emuDB}
\title{Create empty emuDB}
\usage{
create_emuDB(name, targetDir, mediaFileExtension = "wav", store = TRUE,
  verbose = TRUE)
}
\arguments{
\item{name}{of new emuDB}

\item{targetDir}{target directory to store the emuDB to}

\item{mediaFileExtension}{defines mediaFileExtention (NOTE: currently only 
'wav' (the default) is supported by all components of EMU)}

\item{store}{store new created emuDB to file system}

\item{verbose}{display infos & show progress bar}
}
\description{
Creates an empty emuDB in the target directory specified
}
\details{
Creates a new directory [name]_emuDB in targetDir. By default the emuDB is created in the R session, 
written to the filesystem and then purged from the R session.
}
\examples{
\dontrun{
# create empty emuDB in folder provided by tempdir()
create_emuDB(name = "myNewEmuDB", 
             targetDir = tempdir())
}
}

