% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsim.R
\docType{methods}
\name{hsim}
\alias{hsim}
\alias{hsim,hspec-method}
\title{Simulate a multivariate Hawkes process.
Generic function hsim.}
\usage{
hsim(object, size = 100, lambda0 = NULL, N0 = NULL)

\S4method{hsim}{hspec}(object, size = 100, lambda0 = NULL, N0 = NULL)
}
\arguments{
\item{object}{\code{\link{hspec-class}}. This object includes the parameter values.}

\item{size}{the number of observations.}

\item{lambda0}{the starting values of lambda component. numeric or matrix.}

\item{N0}{the starting values of N}
}
\value{
hreal S3-object, summary of the realization of the Haweks model
}
\description{
Simulate a multivariate Hawkes process.
Generic function hsim.

The method simulate multivariate Hawkes processes.
The object \code{\link{hspec-class}} contains the parameter values such as \code{mu}, \code{alpha}, \code{beta}.
The mark (jump) structure may or may not be included.
It returns an object of class \code{hreal} which contains \code{inter_arrival}, \code{arrival},
\code{type}, \code{mark}, \code{N}, \code{Nc}, \code{lambda}, \code{lambda_component}, \code{rambda}, \code{rambda_component}.
}
\examples{
mu <- c(0.1, 0.1)
alpha <- matrix(c(0.2, 0.1, 0.1, 0.2), nrow=2, byrow=TRUE)
beta <- matrix(c(0.9, 0.9, 0.9, 0.9), nrow=2, byrow=TRUE)
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
res <- hsim(h, size=100)

}
