% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{resultNest_newp}
\alias{resultNest_newp}
\title{Fit using the nest database with anchored parameters}
\format{A list with fitted information about data(nest) with anchored parameters}
\usage{
resultNest_newp
}
\description{
Fit using the nest database with anchored parameters
}
\details{
Result of the fit using the nest database with anchored parameters
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
newp <- GenerateAnchor(nests=formated, number.anchors=7)
pfixed <- c(rK=2.093313)
resultNest_newp <- searchR(parameters=newp, fixed.parameters=pfixed,
  temperatures=formated, derivate=dydt.Gompertz, M0=1.7,
	test=c(Mean=39.33, SD=1.92), method = "BFGS", maxiter = 200)
data(resultNest_newp)
}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\references{
Girondot, M. & Kaska, Y. Submitted. A model to predict
            temperature dependency on embryo growth rate and incubation
            duration from field data.
}
\keyword{datasets}

