% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{resultNest_4p_weight}
\alias{resultNest_4p_weight}
\title{Fit using the nest database with weight}
\format{A list with fitted information about data(nest)}
\usage{
resultNest_4p_weight
}
\description{
Fit using the nest database with weight
}
\details{
Result of the fit using the nest database with weight
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
w <- weightmaxentropy(formated, control_plot=list(xlim=c(20,36)))
x <- structure(c(118.768297442004, 475.750095909406, 306.243694918151,
116.055824800264), .Names = c("DHA", "DHH", "T12H", "Rho25"))
# pfixed <- c(K=82.33) or rK=82.33/39.33
pfixed <- c(rK=2.093313)
# K or rK are not used for dydt.linear or dydt.exponential
resultNest_4p_weight <- searchR(parameters=x,
	fixed.parameters=pfixed, temperatures=formated,
	derivate=dydt.Gompertz, M0=1.7, test=c(Mean=39.33, SD=1.92),
	method = "BFGS", maxiter = 200, weight=w)
data(resultNest_4p_weight)
plotR(resultNest_4p_weight, ylim=c(0,0.50), xlim=c(15, 35))
}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\references{
Girondot, M. & Kaska, Y. Submitted. A model to predict
            temperature dependency on embryo growth rate and incubation
            duration from field data.
}
\keyword{datasets}

