% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_link_operator_diff_mat_based_on_tp_predictions}
\alias{get_avg_link_operator_diff_mat_based_on_tp_predictions}
\title{Get average link operator difference matrix based on the number of true positives}
\usage{
get_avg_link_operator_diff_mat_based_on_tp_predictions(models,
  models.synergies.tp, models.link.operator)
}
\arguments{
\item{models}{character vector. The model names.}

\item{models.synergies.tp}{an integer vector of TP values. The \emph{names}
attribute holds the models' names and have to be in the same order as in the
\code{models} parameter.}

\item{models.link.operator}{matrix (nxm) with n models and m nodes. The row names of the matrix
specify the models' names whereas the column names specify the name of the
network nodes (gene, proteins, etc.). Possible values for each \emph{model-node
element} are either \emph{0} (\strong{AND NOT} link operator), \emph{1}
(\strong{OR NOT} link operator) or \emph{0.5} if the node is not targeted by
both activating and inhibiting regulators (no link operator).}
}
\value{
a matrix whose rows are \strong{vectors of average node link operator
differences} between two groups of models based on some kind of classification
(e.g. number of TP predictions) and whose names are set in the \code{rownames}
attribute of the matrix (usually denoting the different classification
groups, e.g. (1,2) means the models that predicted 1 TP synergy vs the models
that predicted 2 TP synergies, if the classification is done by number of TP
predictions). The columns represent the network's node names. Values are in
the [-1,1] interval.
}
\description{
This function uses the \code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}}
function with the parameter \code{models.link.operator} as input in the place of
\code{models.stable.state}, since the two matrices representing the two inputs
have the same data format (rows represent models, columns represent nodes,
and each value is a number in the [0,1] interval).
}
\section{Details}{

So, if a node has a value close to -1 it means that on average,
this node's boolean equation has the \strong{AND NOT} link operator in the
'good' models compared to the 'bad' ones while a value closer to 1 means that
the node's boolean equation has mostly the \strong{OR NOT} link operator
in the 'good' models. A value closer to 0 indicates that the link operator in
the node's boolean equation is \strong{not so much different} between the
'good' and 'bad' models and so it won't not be a node of interest when
searching for indicators of better performance (higher number of true positives)
in the parameterization of the good models (the boolean equations). A value
exactly equal to 0 can also mean that this node didn't not have a link operator
in its boolean equation, again making it a non-important indicator of difference
in model performance.
}

\seealso{
Other average data difference functions: \code{\link{get_avg_activity_diff_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}},
  \code{\link{get_avg_activity_diff_based_on_tp_predictions}},
  \code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}}
}
\concept{average data difference functions}
