% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLike.em.glm.R
\name{logLik.em.glm}
\alias{logLik.em.glm}
\title{Calculate log-likelihood of the EM model.}
\usage{
\method{logLik}{em.glm}(object, x, y, weight = c(1), ...)
}
\arguments{
\item{object}{A 'em.glm' class returned by the em.glm function.}

\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{...}{optionally more fitted model objects.}
}
\value{
Model log-likelihood.
}
\description{
Calculate log-likelihood of the EM model.
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks
m <- em.glm(x = x, y = y, K = 2, b.init = "random")
logLik(m, x, y)

}
