% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_point.R
\name{get_epqs}
\alias{get_epqs}
\title{Get point elevation data from the USGS Elevation Point Query Service}
\usage{
get_epqs(
  locations,
  units = c("meters", "feet"),
  ncpu = future::availableCores() - 1,
  serial = NULL
)
}
\arguments{
\item{locations}{A SpatialPointsDataFrame of the location(s) for which you 
wish to return elevation. The first column is Longitude and 
the second column is Latitude.}

\item{units}{Character string of either meters or feet. Conversions for 
'epqs' are handled by the API itself.}

\item{ncpu}{Number of CPU's to use when downloading epqs data.}

\item{serial}{Logical to determine if API should be hit in serial or in 
parallel.  TRUE will use purrr, FALSE will use furrr.}
}
\value{
a list with a SpatialPointsDataFrame or sf POINT or MULTIPOINT object with 
        elevation added to the data slot and a character of the elevation units
}
\description{
Function for accessing elevation data from the USGS epqs
}
\keyword{internal}
