% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kiwi.R
\name{Kiwi}
\alias{Kiwi}
\title{Kiwi Class}
\description{
Kiwi class is provide method for korean mophological analyze result.
}
\examples{
\dontrun{
  kw <- Kiwi$new()
  kw$analyze("test")
  kw$tokenize("test")
  }

## ------------------------------------------------
## Method `Kiwi$get_tidytext_func`
## ------------------------------------------------

\dontrun{
   kw <- Kiwi$new()
   tidytoken <- kw$get_tidytext_func()
   tidytoken("test")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{Kiwi$print()}}
\item \href{#method-new}{\code{Kiwi$new()}}
\item \href{#method-add_user_word}{\code{Kiwi$add_user_word()}}
\item \href{#method-add_pre_analyzed_words}{\code{Kiwi$add_pre_analyzed_words()}}
\item \href{#method-add_rules}{\code{Kiwi$add_rules()}}
\item \href{#method-load_user_dictionarys}{\code{Kiwi$load_user_dictionarys()}}
\item \href{#method-extract_words}{\code{Kiwi$extract_words()}}
\item \href{#method-analyze}{\code{Kiwi$analyze()}}
\item \href{#method-tokenize}{\code{Kiwi$tokenize()}}
\item \href{#method-split_into_sents}{\code{Kiwi$split_into_sents()}}
\item \href{#method-get_tidytext_func}{\code{Kiwi$get_tidytext_func()}}
\item \href{#method-clone}{\code{Kiwi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{Kiwi} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a kiwi instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$new(
  num_workers = 0,
  model_size = "base",
  integrate_allomorph = TRUE,
  load_default_dict = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_workers}}{\code{int(optional)}: use multi-thread core number. default is 0 which means use all core.}

\item{\code{model_size}}{\code{char(optional)}: kiwi model select. default is "base". "small", "large" is available.}

\item{\code{integrate_allomorph}}{\code{bool(optional)}: default is TRUE.}

\item{\code{load_default_dict}}{\code{bool(optional)}: use defualt dictionary. default is TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_user_word"></a>}}
\if{latex}{\out{\hypertarget{method-add_user_word}{}}}
\subsection{Method \code{add_user_word()}}{
add user word with pos and score
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$add_user_word(word, tag, score, orig_word = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{word}}{\code{char(required)}: target word to add.}

\item{\code{tag}}{\code{Tags(required)}: tag information about word.}

\item{\code{score}}{\code{num(required)}: score information about word.}

\item{\code{orig_word}}{\code{char(optional)}: origin word.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_pre_analyzed_words"></a>}}
\if{latex}{\out{\hypertarget{method-add_pre_analyzed_words}{}}}
\subsection{Method \code{add_pre_analyzed_words()}}{
TODO
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$add_pre_analyzed_words(form, analyzed, score)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{form}}{\code{char(required)}: target word to add analyzed result.}

\item{\code{analyzed}}{\code{data.frame(required)}: analyzed result expected.}

\item{\code{score}}{\code{num(required)}: score information about pre analyzed result.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_rules"></a>}}
\if{latex}{\out{\hypertarget{method-add_rules}{}}}
\subsection{Method \code{add_rules()}}{
TODO
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$add_rules(tag, pattern, replacement, score)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tag}}{\code{Tags(required)}: target tag to add rules.}

\item{\code{pattern}}{\code{char(required)}: regular expression.}

\item{\code{replacement}}{\code{char(required)}: replace text.}

\item{\code{score}}{\code{num(required)}: score information about rules.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_user_dictionarys"></a>}}
\if{latex}{\out{\hypertarget{method-load_user_dictionarys}{}}}
\subsection{Method \code{load_user_dictionarys()}}{
add user dictionary using text file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$load_user_dictionarys(user_dict_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_dict_path}}{\code{char(required)}: path of user dictionary file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-extract_words"></a>}}
\if{latex}{\out{\hypertarget{method-extract_words}{}}}
\subsection{Method \code{extract_words()}}{
Extract Noun word candidate from texts.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$extract_words(input, min_cnt, max_word_len, min_score, pos_threshold)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{\code{char(required)}: target text data}

\item{\code{min_cnt}}{\code{int(required)}: minimum count of word in text.}

\item{\code{max_word_len}}{\code{int(required)}: max word length.}

\item{\code{min_score}}{\code{num(required)}: minimum score.}

\item{\code{pos_threshold}}{\code{num(required)}: pos threashold.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-analyze}{}}}
\subsection{Method \code{analyze()}}{
Analyze text to token and tag results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$analyze(text, top_n = 3, match_option = Match$ALL, stopwords = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{\code{char(required)}: target text.}

\item{\code{top_n}}{\code{int(optional)}: number of result. Default is 3.}

\item{\code{match_option}}{match_option \code{\link{Match}}: use Match. Default is Match$ALL}

\item{\code{stopwords}}{stopwords option. Default is FALSE which is use nothing.
If \code{TRUE}, use embaded stopwords dictionany.
If \code{char}: path of dictionary txt file, use file.
If \code{\link{Stopwords}} class, use it.
If not valid value, work same as FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list} of result.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tokenize"></a>}}
\if{latex}{\out{\hypertarget{method-tokenize}{}}}
\subsection{Method \code{tokenize()}}{
Analyze text to token and pos result just top 1.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$tokenize(
  text,
  match_option = Match$ALL,
  stopwords = FALSE,
  form = "tibble"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{\code{char(required)}: target text.}

\item{\code{match_option}}{match_option \code{\link{Match}}: use Match. Default is Match$ALL}

\item{\code{stopwords}}{stopwords option. Default is FALSE which is use nothing.
If \code{TRUE}, use embaded stopwords dictionany.
If \code{char}: path of dictionary txt file, use file.
If \code{\link{Stopwords}} class, use it.
If not valid value, work same as FALSE.}

\item{\code{form}}{\code{char(optional)}: return form. default is "tibble".
"list", "tidytext" is available.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-split_into_sents"></a>}}
\if{latex}{\out{\hypertarget{method-split_into_sents}{}}}
\subsection{Method \code{split_into_sents()}}{
Some text may not split sentence by sentence.
split_into_sents works split sentences to sentence by sentence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$split_into_sents(text, match_option = Match$ALL, return_tokens = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{\code{char(required)}: target text.}

\item{\code{match_option}}{match_option \code{\link{Match}}: use Match. Default is Match$ALL}

\item{\code{return_tokens}}{\code{bool(optional)}: add tokenized resault.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_tidytext_func"></a>}}
\if{latex}{\out{\hypertarget{method-get_tidytext_func}{}}}
\subsection{Method \code{get_tidytext_func()}}{
set function to tidytext unnest_tokens.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$get_tidytext_func(match_option = Match$ALL, stopwords = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{match_option}}{match_option \code{\link{Match}}: use Match. Default is Match$ALL}

\item{\code{stopwords}}{stopwords option. Default is TRUE which is
to use embaded stopwords dictionary.
If FALSE, use not embaded stopwords dictionary.
If char: path of dictionary txt file, use file.
If \code{\link{Stopwords}} class, use it.
If not valid value, work same as FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{function}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
   kw <- Kiwi$new()
   tidytoken <- kw$get_tidytext_func()
   tidytoken("test")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kiwi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
