% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elaborator_plot_quant_trends.R
\name{elaborator_plot_quant_trends}
\alias{elaborator_plot_quant_trends}
\title{Generates boxplots for each treatment group and laboratory parameter}
\usage{
elaborator_plot_quant_trends(
  dat1,
  signtest = TRUE,
  Visit1,
  Visit2,
  sameaxes = FALSE,
  ats = NULL,
  cols = NULL,
  labelvis = NULL,
  labcolumn,
  sortpoints = FALSE,
  pcutoff = 0.01,
  cexoutliers = 0.7,
  infotest = NULL,
  sortinput = as.character(unique(dat1[, labcolumn])),
  bordercol = NULL,
  add_points = TRUE,
  connect_lines = FALSE
)
}
\arguments{
\item{dat1}{data set}

\item{signtest}{logical, if true sign test, otherwise t-test for comparing Visit1 and Visit2 is performed}

\item{Visit1}{name of visit time point one}

\item{Visit2}{name of visit time point two, or vector of visit names for pairwise comparison to Visit1}

\item{sameaxes}{logical indicating if boxplot should have the same y-axis range for all treatment groups within a laboratory parameter}

\item{ats}{numeric vector giving the locations where the boxplots should be drawn; defaults to 1:n where n is the number of boxplots.}

\item{cols}{vector with colors of boxplots}

\item{labelvis}{vector of visit names used for labelling}

\item{labcolumn}{column name of dat1 which includes the laboratory parameter names}

\item{sortpoints}{logical indicating if dots in boxplots should be sorted from smallest to largest}

\item{pcutoff}{numeric for p-value threshold; if p-value of specified test is below this threshold, the background of the respective plot is colorized.}

\item{cexoutliers}{size of the outliers}

\item{infotest}{list object from the perform test function}

\item{sortinput}{vector of laboratory parameter names in the order in which laboratory parameters are presented in the output}

\item{bordercol}{color of boxes which are not selected for hypothesis testing}

\item{add_points}{logical indicating if points showing patients' values should be added to the boxplots}

\item{connect_lines}{logical indicating if subject values should be connected between visits via lines}
}
\value{
No return value. Generates plots for the quantitative trends analysis.
}
\description{
Generate boxplots showing the distribution of laboratory values at each visits of a study separately by treatment group and laboratory parameter according to the quantitative trend analysis.
}
\keyword{internal}
