% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_OR_to_RR.R
\name{oddsratio_to_riskratio}
\alias{oddsratio_to_riskratio}
\alias{riskratio_to_oddsratio}
\title{Convert between Odds ratios and Risk ratios}
\usage{
oddsratio_to_riskratio(OR, p0, log = FALSE, ...)

riskratio_to_oddsratio(RR, p0, log = FALSE)
}
\arguments{
\item{OR, RR}{Risk ratio of \code{p1/p0} or Odds ratio of \code{odds(p1)/odds(p0)},
possibly log-ed. \code{OR} can also be a logistic regression model.}

\item{p0}{Baseline risk}

\item{log}{Take in or output the log of the ratio (such as in logistic models).}

\item{...}{Arguments passed to and from other methods.}
}
\value{
Converted index, or if \code{OR} is a logistic regression model, a
parameter table with the converted indices.
}
\description{
Convert between Odds ratios and Risk ratios
}
\examples{
p0 <- 0.4
p1 <- 0.7

(OR <- probs_to_odds(p1) / probs_to_odds(p0))
(RR <- p1 / p0)

riskratio_to_oddsratio(RR, p0 = p0)
oddsratio_to_riskratio(OR, p0 = p0)

m <- glm(am ~ factor(cyl), data = mtcars,
         family = binomial())
oddsratio_to_riskratio(m)
}
\references{
Grant, R. L. (2014). Converting an odds ratio to a range of plausible
relative risks for better communication of research findings. Bmj, 348,
f7450.
}
\seealso{
Other convert between effect sizes: 
\code{\link{d_to_common_language}()},
\code{\link{d_to_r}()},
\code{\link{eta2_to_f2}()},
\code{\link{odds_to_probs}()}
}
\concept{convert between effect sizes}
