% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_metrics.R
\name{eem_coble_peaks}
\alias{eem_coble_peaks}
\title{Extrace fluorescence peaks}
\usage{
eem_coble_peaks(eem, verbose = TRUE)
}
\arguments{
\item{eem}{An object of class \code{eem}}

\item{verbose}{Logical determining if additional messages should be printed.}
}
\value{
A data frame containing peaks B, T, A, M and C for each eem.
}
\description{
Extrace fluorescence peaks
}
\section{Interpolation}{


  Different excitation and emission wavelenghts are often used to measure
  EEMs. Hence, it is possible to have mismatchs bewteen measured wavelengths
  and wavelenghts used to calculate specific metrics. In these circumstances,
  EEMs are interpolated using the \code{\link{interp2}} function from the
  \code{parcma} library. A message warning the user will be prompted
  if data interpolation is performed.
}
\examples{
file <- system.file("extdata/cary/eem/", "sample1.csv", package = "eemR")
eem <- eem_read(file)

eem_coble_peaks(eem)
}
\seealso{
\link[pracma]{interp2}
}

