% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-download.R
\name{sF_download}
\alias{sF_download}
\title{Download SpatialPolygonsDataFrame containing polygons of Australian federal electorates}
\usage{
sF_download(year, ...)
}
\arguments{
\item{year}{Desired year, must be one of 2001, 2004, 2007, 2010, 2011, 2013, 2016}

\item{...}{Additional arguments passed to `download.file`

Downloads and returns a large SpatialPolygonsDataFrame containing the polygons 
and associated data for each of the 150 Australian electorates in the 2001 federal election. 
This object is obtained using the `sF_download` function. The data were obtained from the 
Australian Electoral Commission and the Australian Bureau of Statistics.}
}
\value{
A SpatialPolygonsDataFrame containing polygons of the 150 Australian federal electorates
}
\description{
Download SpatialPolygonsDataFrame containing polygons of Australian federal electorates
}
\examples{
\dontrun{
sF_16 <- sF_download(year = 2016)
# Plot a map of the electorates
library(sp)
plot(sF_16)
}

}
