% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapefiles.R
\name{load_shapefile}
\alias{load_shapefile}
\title{Load shapefile of Australia into R}
\usage{
load_shapefile(path_to_shapeFile, tolerance = 0.005)
}
\arguments{
\item{path_to_shapeFile}{path to object in local machine}

\item{tolerance}{numerical tolerance value to be used by the Douglas-Peuker algorithm}
}
\value{
object of class SpatialPolygonsDataFrame
}
\description{
Load shapefile into R as a SpatialDataFrame, extract polygon information, thin
polygon, fix any problematic polygons, and format variable names.
"nat_map" and "nat_data" objects for every Australian federal election between 
2001-2016 can be readily loaded from the package for analysis.
}
\details{
The function will take several minutes to complete.
}
\examples{
\dontrun{
# Load electorate shapefile into R

# Path to your shapefile
fl <- "local/path/to/shapefile.shp"

# Load
my_sF <- load_shapefile(fl)
}
}
