% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getNiceAlignment}
\alias{getNiceAlignment}
\title{Output alignments from align() in NICE format. This outputs the alignment from align() in a visually informative format for human inspection.}
\usage{
getNiceAlignment(alignResult, query, target, gapSymbol = "-")
}
\arguments{
\item{alignResult}{list Output of the method align() 
Note: align() requires the argument task="path" for 'alignResult' to output a CIGAR for getNiceAlignment()
Note: Also, align() requires the argument cigarFormat="extended" in order for getNiceAlignment() to work}

\item{query}{character string The exact query used for alignResult}

\item{target}{character string The exact target used for alignResult}

\item{gapSymbol}{character (default="-") Character used to represent gaps in the alignment between query and target. This must be a single character, i.e. a string of length 1.}
}
\value{
Alignment in NICE format, which is an informative visual representation of how the query and target align to each other. 
    e.g., for "telephone" and "elephant", it would look like:
       telephone
        |||||.|.
       -elephant
    It is represented as an R list with the following fields:
      - query_aligned (character string)
      - matched_aligned (character string) ('|' for match, '.' for mismatch, ' ' for insertion/deletion)
      - target_aligned (character string)
    Normally you will want to print these three in order above with the function nice_print(), or another method to apply pretty-printing to R lists
}
\description{
Output alignments from align() in NICE format. This outputs the alignment from align() in a visually informative format for human inspection.
}
\examples{
query = "elephant"
target = "telephone"
result = align(query, target, task = "path")
nice_algn = getNiceAlignment(result, query, target)

}
