% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBusinessDescr.R
\name{getBusinDescr}
\alias{getBusinDescr}
\title{Retrieves business descriptions from annual statements}
\usage{
getBusinDescr(cik.no, filing.year)
}
\arguments{
\item{cik.no}{vector of firm CIK numbers in integer format. Suppress leading 
zeroes from CIKs.}

\item{filing.year}{vector of four digit numeric year}
}
\value{
Function saves scrapped "Item 1" section from annual filings in 
"Business descriptions text" directory present in the working 
directory. The output dataframe contains information on CIK number, 
company name, date of filing, and accession number
}
\description{
\code{getBusinessDescr} retrieves "Item 1. Business" section from annual statements 
based on CIK number(s) and filing year(s).
}
\details{
getBusinDescr function takes firm CIK numbers and filing years as input parameters from 
a user and provides "Item 1" section extracted from annual statements along with 
filing information. The function imports annual filings downloaded 
via \link[edgar]{getFilings} function; otherwise, it downloads the filings which are 
not already been downloaded. It then reads the downloaded statements, cleans HTML tags, 
and parse the contents. It creates a new directory with name 
"Business descriptions text" in the current working directory and 
saves scrapped "Item 1" sections this directory. It considers "10-K", 
"10-K405", "10KSB", and "10KSB40" form types as annual statements.
}
\examples{
\dontrun{

output <- getBusinDescr(cik.no = c(1000180, 38079), filing.year = 2005)
## saves scrapped "Item 1" section from 10-K filings for CIKs in 
"Business descriptions text" directory present 
in the working directory. Also, it provides filing information in 
the output datframe.

output <- getBusinDescr(cik.no = c(1000180, 38079), 
                        filing.year = c(2005, 2006))
}
}
