% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_case.R
\name{filter_case}
\alias{filter_case}
\alias{filter_case.eventlog}
\alias{filter_case.grouped_eventlog}
\alias{ifilter_case}
\title{title Filter: Case}
\usage{
filter_case(eventlog, cases, reverse)

\method{filter_case}{eventlog}(eventlog, cases = NULL, reverse = FALSE)

\method{filter_case}{grouped_eventlog}(eventlog, cases = NULL,
  reverse = FALSE)

ifilter_case(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{cases}{A vector of cases identifiers}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based on case identifier
}
\details{
The method filter_case can be used to filter on case identifiers. It has an cases argument,
to which a vector of identifiers can be given. The selection can be negated with the reverse argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter for eventlogs

\item \code{grouped_eventlog}: Stratified filter for grouped eventlogs
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
