% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_activity_presence.R
\name{filter_activity_presence}
\alias{filter_activity_presence}
\alias{filter_activity_presence.eventlog}
\alias{filter_activity_presence.grouped_eventlog}
\alias{ifilter_activity_presence}
\title{Filter: Activity Presence}
\usage{
filter_activity_presence(eventlog, activities, method, reverse)

\method{filter_activity_presence}{eventlog}(eventlog, activities = NULL,
  method = c("all", "one_of", "none", "exact", "only"), reverse = FALSE)

\method{filter_activity_presence}{grouped_eventlog}(eventlog,
  activities = NULL, method = c("all", "one_of", "none", "exact", "only"),
  reverse = FALSE)

ifilter_activity_presence(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{activities}{Character vector containing one or more activity identifiers.}

\item{method}{Filter method. If "all", each of the activities should be present. If "one_of", at least one of them should be present. If "none", none of the activities are allowed to occur in the filtered traces.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters cases based on the presence (or absence) of activities
}
\details{
This functions allows to filter cases that contain certain activities.
It requires as input a vector containing one or more activity labels and it has a method
argument. The latter can have the values all, none or one_of.
\itemize{
\item When set to `all`, it means
that all the specified activity labels must be present for a case to be selected
\item `none` means
that they are not allowed to be present.
\item `one_of` means that at least one of them must be
present.
\item `only` means that only (a set of) these activities are allowed to be present
\item `exact` means that only exactly these activities can be present (although multiple times and in random orderings)
}

When only one activity label is supplied, note that methods all and one_of will be identical.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log on presence of activities.

\item \code{grouped_eventlog}: Filter grouped event log on presence of activities.
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
