% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_endpoints.R
\name{filter_endpoints}
\alias{filter_endpoints}
\alias{filter_endpoints.eventlog}
\alias{filter_endpoints.grouped_eventlog}
\alias{ifilter_endpoints}
\title{Filter: Start and end activities}
\usage{
filter_endpoints(eventlog, start_activities, end_activities, percentage,
  reverse, ...)

\method{filter_endpoints}{eventlog}(eventlog, start_activities = NULL,
  end_activities = NULL, percentage = NULL, reverse = FALSE, ...)

\method{filter_endpoints}{grouped_eventlog}(eventlog, start_activities = NULL,
  end_activities = NULL, percentage = NULL, reverse = FALSE, ...)

ifilter_endpoints(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{start_activities}{A vector of activity identifiers, or NULL}

\item{end_activities}{A vector of activity identifiers, or NULL}

\item{percentage}{A percentage p to be used as percentile cut off. When this is used, the most common endpoint-pairs will be selected until at least
the p\% of the cases are selected.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based on a provided set of start and end activities
}
\details{
The filter_endpoints method filters cases based on the first and last activity label. It can be used in two ways: by specifying vectors with allowed start
activities and/or allowed end activities, or by specifying a percentile. In the latter case, the percentile value will be used as a cut off.
For example, when set to 0.9, it will select the most common endpoint pairs which together cover at least 90% of the cases, and filter the event log accordingly.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log stratified
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
