% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeHV.R
\name{computeHV}
\alias{computeHV}
\alias{computeHVContr}
\title{Functions for the calculation of the dominated hypervolume (contribution).}
\usage{
computeHV(x, ref.point = NULL)

computeHVContr(x, ref.point = NULL, offset = 1)
}
\arguments{
\item{x}{[\code{matrix}]\cr
Matrix of points (column-wise).}

\item{ref.point}{[\code{numeric} | \code{NULL}]\cr
Reference point.
Set to the maximum in each dimension by default if not provided.}

\item{offset}{[\code{numeric(1)}]\cr
Offset to be added to each component of the reference point only in the case
where no reference is provided and one is calculated automatically.}
}
\value{
[\code{numeric(1)}] Dominated hypervolume in the case of
 \code{computeHV} and the dominated hypervolume contributions
 for each point in the case of \code{computeHVContr}.
}
\description{
The function \code{computeHV} computes the dominated
hypervolume of a set of points given a reference set whereby
\code{computeHVContr} computes the hypervolume contribution
of each point.

If no reference point is given the nadir point of the set \code{x} is
determined and a positive offset with default 1 is added. This is to ensure
that the reference point dominates all of the points in the reference set.
}
\note{
: Keep in mind that this function assumes all objectives to be minimized.
In case at least one objective is to be maximized the matrix \code{x} needs
to be transformed accordingly in advance.
}
