% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_test.R
\name{ratio_test}
\alias{ratio_test}
\title{Ratio test}
\usage{
ratio_test(model_1, model_2, percentage = NULL,
           type = c("probit", "logit"), log_base = NULL, log_x = TRUE)
}
\arguments{
\item{model_1}{first model used in the ratio test. Should be an object of either a probit or logit model created using the \code{glm()} function. See example.}

\item{model_2}{second model used in the ratio test. Should be an object of either a probit or logit model created using the \code{glm()} function. See example.}

\item{percentage}{either a single value or a vector for given LC or LT percentage desired to compare. Percentage is the same value used for the argument \code{p} in all \code{LC_} and \code{LT_} functions. For example, 50 will return and compare LC50 values for the two models. If more than one LC value is disired specify by creating a vector. LC values can be calculated down to the 1e-16 of a percentage (e.g. LC99.99). However, the tibble produced can and will round to nearest whole number.}

\item{type}{Link type needs to be specfied to either \code{"probit"} which will return and used in calculations for a probit model for the desired LCs or LTs. If specified to \code{"logit"} then \code{ratio_test} will return and calcuate using a logit model for the desired LCs or LTs.}

\item{log_base}{default is \code{10} and will be used to  calculate results using the anti of \code{log10()} given that the x variable has been \code{log10} tranformed. If \code{FALSE} results will not be back transformed.}

\item{log_x}{default is \code{TRUE} and will calculate results using the antilog of determined by \code{log_base} given that the x variable has been \code{log()} tranformed. If \code{FALSE} results will not be back transformed.}
}
\value{
A tibble with \code{percentage} for the LC or LT value desired for the above percentage argument, \code{dose_1} and \code{dose_2} displayed calculated backtransformed or untransformed doses for the desired LC or LT values. Standard Error (\code{se}), Z test statistic (\code{test_stat}) and \code{p} value detemined using Z test statistic as determined using formulas in \href{http://onlinelibrary.wiley.com/doi/10.1897/05-320R.1/abstract}{Wheeler et al. 2006}.
.
}
\description{
Calculates a ratio test to compare two LC or LT values from two seperate probit or logit models. This function is based on the ratio test developed in \href{http://onlinelibrary.wiley.com/doi/10.1897/05-320R.1/abstract}{Wheeler et al. 2006. 10.1897/05-320R.1} which has been suggested as a replacement to the common method of comparing confidence intervals to determine differences.
}
\examples{
# view lamprey_tox data

head(lamprey_tox)

# using glm() to detemine LC values using probit model for May and June

m <- glm((response / total) ~ log10(dose),
         data = lamprey_tox,
         subset = c(month == "May"),
         weights = total,
         family = binomial(link = "probit"))


j <- glm((response / total) ~ log10(dose),
         data = lamprey_tox,
         subset = c(month == "June"),
         weights = total,
         family = binomial(link = "probit"))

# now that both May and June models have been made. use ratio_test to
# compare LC50 values or whatever LC values of interest.

ratios <- ratio_test(model_1 = m, model_2 = j, percentage = 50, type = "probit")

# view ratio test results

ratios

}
\references{
Wheeler, M.W., Park, R.M., and Bailey, A.J., 2006. Comparing median lethal concentration values using confidence interval overlap or ratio tests, Environ. Toxic. Chem. 25(5), 1441-1444.\href{http://onlinelibrary.wiley.com/doi/10.1897/05-320R.1/abstract}{10.1897/05-320R.1}
}
