% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.similarity}
\alias{plot.similarity}
\title{Function to generate heatmap}
\usage{
\method{plot}{similarity}(x, color = viridis::viridis(100), truemodule,
  active, ...)
}
\arguments{
\item{x}{an object of class similarity. This is a p x p symmetric matix such
as a correlation matrix or a TOM matrix, where p is the number of genes}

\item{color}{colors for the heatmap. By default it uses the \code{viridis}
color scheme. The \code{viridis} package needs to be installed.}

\item{truemodule}{a numeric vector of length p where p is the number of
genes, giving the module membership. By default, 0 = Grey, 1 = Turquoise, 2
= Blue, 3 = Red, 4 = Green, and 5 = Yellow. This information is used for
annotating the heatmap}

\item{active}{a binary vector of length p (where p is the number of genes)
where 0 means that gene is not related to the response, and 1 means that
the gene is associated to the response.}

\item{...}{other arguments passed to the pheatmap function}
}
\value{
a heatmap of a similarity matrix
}
\description{
Plots a heatmap of a similarity matrix such as a correlation
  matrix or a TOM matrix. This function is a plotting method for an object of
  class similarity. These objects are returned by the
  \code{\link{s_generate_data}} and \code{\link{s_generate_data_mars}}
  functions
}
\note{
this function is only meant to be used with output from the
  \code{\link{s_generate_data}} and \code{\link{s_generate_data_mars}}
  functions, since it assumes a fixed number of modules.
}
\examples{
\dontrun{
corrX <- cor(simdata[,c(-1,-2)])
class(corrX) <- append(class(corrX), "similarity")
plot(corrX, truemodule = c(rep(1:5, each=150), rep(0, 250)))
}
}

