% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo_package_functions.R
\name{smoothing_all_tied}
\alias{smoothing_all_tied}
\title{Function to calculate a rolling average (3-wide window) for a set of data (smoothing) for paired (tied) replicates, which smooths each replicate separately.}
\usage{
smoothing_all_tied(is_weighted, num_reps, genes, tied, timen)
}
\arguments{
\item{is_weighted}{boolean if there is smoothing, is it weighted (1,2,1) smoothing,  or unweighted smoothing (1,1,1)}

\item{num_reps}{number of replicates}

\item{genes}{data frame of genes with the following specifications: first row is column labels, first column has gene labels/names, and all other columns have expression data. This expression data must be ordered by time point then by replicate, and must have evenly spaced time points. Any missing data must have cells left blank.}

\item{tied}{whether replicates are paired (tied) or unpaired (untied)}

\item{timen}{vector of time points for gene expression}
}
\value{
smoothed expression data
}
\description{
Function to calculate a rolling average (3-wide window) for a set of data (smoothing) for paired (tied) replicates, which smooths each replicate separately.
}
