% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.inspect}
\alias{ec.inspect}
\title{Chart to JSON}
\usage{
ec.inspect(wt, target = NULL, json = TRUE, ...)
}
\arguments{
\item{wt}{An \code{echarty} widget as returned by \link{ec.init}}

\item{target}{NULL(default) or 'data' to show info about chart's embedded data.}

\item{json}{Boolean whether to return a JSON, or a \code{list}, default TRUE}

\item{...}{Additional arguments to pass to \code{\link[jsonlite]{toJSON}}}
}
\value{
A JSON string if \code{json} is \code{TRUE} and
a \code{list} otherwise.
}
\description{
Convert chart to JSON string
}
\note{
Must be invoked or chained as last command.
}
\examples{
# extract JSON
json <- cars \%>\% ec.init() \%>\% ec.inspect()
json

# get from JSON and modify plot
ec.fromJson(json) \%>\% ec.theme('macarons')

}
