% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_labels}
\alias{e_labels}
\title{Format labels}
\usage{
e_labels(e, show = TRUE, position = "top", ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{show}{Set to \code{TRUE} to show the labels.}

\item{position}{Position of labels, see
\href{https://echarts.apache.org/en/option.html#series-line.label.position}{official documentation}
 for the full list of options.}

\item{...}{Any other options see
\href{https://echarts.apache.org/en/option.html#series-line.label}{documentation} for other options.}
}
\description{
Format labels
}
\examples{
mtcars \%>\%
  e_chart(wt) \%>\%
  e_scatter(qsec, cyl) \%>\%
  e_labels(fontSize = 9)

mtcars \%>\%
  group_by(cyl) \%>\%
  e_chart(wt) \%>\%
  e_scatter(qsec, mpg) \%>\%
  e_labels(fontSize = 9)

# timeline
mtcars \%>\%
  group_by(cyl) \%>\%
  e_chart(wt) \%>\%
  e_scatter(qsec, mpg) \%>\%
  e_labels(fontSize = 9)
}
