% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{e_radar_opts}
\alias{e_radar_opts}
\title{Radar axis}
\usage{
e_radar_opts(e, index = 0, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{index}{Index of axis to customise.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Radar axis setup and options.
}
\examples{
df <- data.frame(
  x = LETTERS[1:5],
  y = runif(5, 1, 5),
  z = runif(5, 3, 7)
)

df \%>\%
  e_charts(x) \%>\%
  e_radar(y, max = 7) \%>\%
  e_radar(z) \%>\%
  e_radar_opts(center = c("25\%", "25\%")) \%>\% 
  e_tooltip(trigger = "item")

}
