% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdattr-class.R
\docType{class}
\name{ecdattr-class}
\alias{ecdattr-class}
\title{An S4 class to represent the \code{ecdattr} row in the Elliptic Database (ECDB)}
\description{
The \code{ecdattr} class serves as an object-oriented interface 
between R and ECDB. This class is used extensively during
the \code{\link{bootstrap}} process. A list of light-weight \code{ecdattr} 
objects is created first by \code{\link{ecdattr.pairs}} function,
then the \code{\link{ecdattr.enrich}} function is invoked in parallel to calculate 
additional \code{ecd} attributes.
}
\section{Slots}{

\describe{
\item{\code{call}}{the match.call slot}

\item{\code{alpha}}{numeric}

\item{\code{gamma}}{numeric. When cusp is 1, \code{gamma} is derived.}

\item{\code{cusp}}{numeric, representing type of cusp. Only 0 (default) and 1 are allowed.}

\item{\code{use.mpfr}}{logical, whether to use mpfr for ecd object.}

\item{\code{enriched}}{logical. If \code{TRUE}, it indicates the object has been enriched with ecd attributes.}

\item{\code{alpha_m}}{numeric, \code{alpha}*1000000.}

\item{\code{gamma_m}}{numeric, \code{gamma}*1000000.}

\item{\code{ecd}}{an object of ecd class.}

\item{\code{attr}}{list of attributes. They are \code{NULL} protected for SQLite.}
}}
\keyword{ecdattr}

