% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-moment-method.R
\name{ecld.moment}
\alias{ecld.mgf}
\alias{ecld.mgf_by_sum}
\alias{ecld.mgf_quartic}
\alias{ecld.moment}
\title{The moments and MGF of ecld}
\usage{
ecld.moment(object, order, ignore.mu = TRUE)

ecld.mgf(object, t = 1)

ecld.mgf_by_sum(object, t = 1)

ecld.mgf_quartic(object, t = 1)
}
\arguments{
\item{object}{an object of ecd class}

\item{order}{numeric, order of the moment to be computed}

\item{ignore.mu}{logical, disgard mu; otherwise, stop if mu is not zero.}

\item{t}{numeric, for MGF}
}
\value{
numeric
}
\description{
Compute the moments and MGF of ecld for \code{mu=0} (centered),
via analytical result whenever is available.
SGED is supported.
}
\examples{
ld <- ecld(lambda=3, sigma=0.01*ecd.mp1)
ecld.moment(ld, 2)
ecld.mgf(ld)
}
\author{
Stephen H-T. Lihn
}
\keyword{moment}

