% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcmsg.R
\name{tcmsg}
\alias{tcmsg}
\title{tryCatch with Message}
\usage{
tcmsg(code_block, ...)
}
\arguments{
\item{code_block}{Code to run in Try Catch.}

\item{...}{Strings to concatenate to form the message that is returned.}
}
\description{
Easy Try/Catch implementation to return the same message on error or warning. Makes it easier to write tryCatches.
Author: Bryce Chamberlain. Tech review: Lindsay Smelzter.
}
\examples{
tryCatch({ 
   tcmsg({ NULL = 1 }, 'Cannot assign to NULL','variable' ) 
 }, 
 error = function(e) print( e ) 
 )

tryCatch({ 
   tcmsg({ as.numeric('abc') },'Issue in as.numeric()') 
  }, 
  warning = function(e) print( e ) 
)
}
