% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{strings_to_NA}
\alias{strings_to_NA}
\title{Replace values in non-numeric columns with NA}
\usage{
strings_to_NA(data, ..., strings_to_replace = NULL)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like \code{x:y} can
be used to select a range of variables.}

\item{strings_to_replace}{character vector of values to be replaced with
\code{NA}.}
}
\value{
data with specified values replaced with NA.
}
\description{
Replaces specified or pre-defined strings in non-numeric columns with
\code{NA}.
}
\details{
Columns to process can be specified in custom arguments (\code{...}) or will
be applied to all non-numeric columns.
Default strings which will be replaced with \code{NA} are as follows:
"Undetermined", "unknown", "missing", "fail", "fail / unknown", 
"equivocal", "equivocal / unknown", "*".
String search is made using \code{\link[base]{grepl}} and supports
\code{\link[base]{regex}} so metacharacters (\code{. \ | ( ) [ ] {  } ^ $ * + ? $})
should be escaped with a "\code{\\}" prefix.
Matches are case sensitive by default but can ignore case with the parameter: 
\code{ignore.case = TRUE} in \code{...}).
}
\examples{
data(example_data)

# original unique values in diabetes column:
unique(example_data$diabetes)
# Using default values
res <- strings_to_NA(example_data)
unique(res$diabetes)


# original unique values in diabetes_type column:
unique(example_data$diabetes_type)
# Using custom values
res <- strings_to_NA(example_data, strings_to_replace = "Type I")
unique(res$diabetes_type)

}
