% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws.R
\name{as_draws_df.dynamitefit}
\alias{as_draws_df.dynamitefit}
\alias{as_draws_df}
\alias{as_draws.dynamitefit}
\alias{as_draws}
\title{Convert \code{dynamite} Output to \code{draws_df} Format}
\usage{
\method{as_draws_df}{dynamitefit}(x, responses = NULL, types = NULL, ...)

\method{as_draws}{dynamitefit}(x, responses = NULL, types = NULL, ...)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.}

\item{types}{[\code{character()}]\cr Type(s) of the parameters for which the
samples should be extracted. See details of possible values. Default is
all values listed in details except spline coefficients \code{omega} and
\code{omega_alpha}.}

\item{...}{Ignored.}
}
\value{
A \code{draws_df} object.

A \code{draws_df} object.
}
\description{
Converts the output from \code{\link[=dynamite]{dynamite()}} call to a
\code{draws_df} format of the \pkg{posterior} package, enabling the use
of diagnostics and plotting methods of \pkg{posterior} and \pkg{bayesplot}
packages. Note that this function returns all variables in a wide format,
whereas \code{\link[=as.data.frame]{as.data.frame()}} uses the long format.
}
\details{
You can use the arguments \code{responses} and \code{types} to extract only a subset
of the model parameters (i.e., only certain types of parameters related to a
certain response variable).

See potential values for the types argument in
\code{\link[=as.data.frame.dynamitefit]{as.data.frame.dynamitefit()}}
}
\examples{
as_draws(gaussian_example_fit, types = c("sigma", "beta"))

}
