% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF.R
\name{PF_EM}
\alias{PF_EM}
\title{EM estimation with particle filters}
\usage{
PF_EM(formula, data, model = "logit", by, max_T, id, a_0, Q_0, Q, order = 1,
  control = list(), trace = 0)
}
\arguments{
\item{formula}{\code{\link[survival]{coxph}} like formula with \code{\link[survival]{Surv}(tstart, tstop, event)} on the left hand site of \code{~}.}

\item{data}{\code{data.frame} or environment containing the outcome and co-variates.}

\item{model}{either \code{'logit'} for binary outcomes or \code{'exponential'} for piecewise constant exponential distributed arrival times.}

\item{by}{interval length of the bins in which parameters are fixed.}

\item{max_T}{end of the last interval interval.}

\item{id}{vector of ids for each row of the in the design matrix.}

\item{a_0}{vector \eqn{a_0} for the initial coefficient vector for the first iteration (optional). Default is estimates from static model (see \code{\link{static_glm}}).}

\item{Q_0}{covariance matrix for the prior distribution.}

\item{Q}{initial covariance matrix for the state equation.}

\item{order}{order of the random walk.}

\item{control}{list of control variables (see the control section below).}

\item{trace}{argument to get progress information. Zero will yield no info and larger integer values will yield incrementally more information.}
}
\value{
An object of class \code{PF_EM}.
}
\description{
Method to estimate the hyper parameters with an EM algorithm.
}
\details{
See \code{vignette("Particle_filtering", "dynamichazard")} for details.
}
\section{Control}{

The \code{control} argument allows you to pass a \code{list} to select additional parameters. See \code{vignette("Particle_filtering", "dynamichazard")} for details. Unspecified elements of the list will yield default values.
\describe{
\item{\code{method}}{method for forward, backward and smoothing filter.}
\item{\code{smoother}}{smoother to use.}
\item{\code{N_fw_n_bw}}{number of particles to use in forward and backward filter.}
\item{\code{N_first}}{number of particles to use at time \eqn{0} and time \eqn{d + 1}.}
\item{\code{N_smooth}}{number of particles to use in particle smoother.}
\item{\code{eps}}{convergence threshold in EM method.}
\item{\code{n_max}}{maximum number of iterations of the EM algorithm.}
\item{\code{n_threads}}{maximum number threads to use in the computations.}
\item{\code{forward_backward_ESS_threshold}}{required effective sample size to not re-sample in the particle filters.}
\item{\code{seed}}{seed to set at the start of every EM iteration.}
}
}

\examples{
#####
# Fit model with lung data set from survival
# Warning: this has a longer computation time

\dontrun{
library(dynamichazard)
.lung <- lung[!is.na(lung$ph.ecog), ]
set.seed(43588155)
pf_fit <- PF_EM(
 Surv(time, status == 2) ~ ph.ecog + age,
 data = .lung, by = 50, id = 1:nrow(.lung),
 Q_0 = diag(1, 3), Q = diag(1, 3),
 max_T = 800,
 control = list(
   N_fw_n_bw = 500,
   N_first = 2500,
   N_smooth = 2500,
   n_max = 50,
   n_threads = parallel::detectCores()),
 trace = 1)

# Plot state vector estimates
plot(pf_fit, cov_index = 1)
plot(pf_fit, cov_index = 2)
plot(pf_fit, cov_index = 3)

# Plot log-likelihood
plot(pf_fit$log_likes)}

#####
# Can be compared with this example from ?coxph in R 3.4.1. Though, the above
# only has a linear effect for age

\dontrun{
cox <- coxph(
 Surv(time, status) ~ ph.ecog + tt(age), data= .lung,
 tt=function(x,t,...) pspline(x + t/365.25))
cox}
}
