% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associateData-method.R
\docType{methods}
\name{associateData}
\alias{associateData}
\title{Identify associations of trajectories within a data set or across two data sets}
\usage{
associateData(data1,data2,numCores)
}
\arguments{
\item{data1}{\code{data.frame} or \code{matrix} containing the time as rows and features as columns}

\item{data2}{optional an additional \code{data.frame} or \code{matrix} containing the time as rows and features as columns}

\item{numCores}{alternative \code{numeric} value indicating the number of CPU cores to be used for parallelization. Default value is automatically estimated.}
}
\value{
associateData returns an object of class \code{associations} containing the following components:
\itemize{
\item{Feature1}{ \code{character} the colnames or the index of data1.}
\item{Feature2}{ \code{character} the colnames or the index of data2.}
\item{delay}{ \code{numeric} estimated delay between feature1 and feature2.} 
\item{pBefore}{ \code{numeric} p-value of the test for association before applying the predicted time shift.}
\item{pAfter}{ \code{numeric} p-value of the test for association after applying the predicted time shift.}
\item{corBefore}{ \code{numeric} Pearson correlation before applying the predicted time shift.} 
\item{corAfter}{ \code{numeric} Pearson correlation after applying the predicted time shift.}
}
}
\description{
Function to estimate differences in expression initation of trajectories to identify associations between time course 'omics' data.
}
\details{
associateData() takes as input two data sets of interest and performs a pairwise associations comparison between features using a fast Fourier transform approach to detect delays (also called 'associations') between the different features. Note that the argument `numCores` indicates the number of CPUs  and is detected by default in the function to perform parallelization. The final result is a table with a row for each pairwise comparison. The output presents the dynOmics estimated delay between two features, the p-value (`p`) and correlation coefficient (`cor`) from a Pearson's test, before and after the time profiles have been realigned according to the dynOmics estimated delay.
}
\examples{
data(SmallExampleMetabTransc)
associations <- associateData(Metabolites[,1],Transcripts[,1:50])
summary(associations)
plot(associations,Metabolites,Transcripts,feature1=1)
}
\references{
Straube J., Bernard A., Huang B.E., Le Cao K.-A.(2015).  \emph{DynOmics - A new algorithm using fast Fourier transform to reveal dynamic molecule interactions } In preparation
}
\seealso{
\code{\link{summary.associations}}, \code{\link{plot.associations}}
}

