/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import criteres.Critere;
import criteres.CriterePositifNegatif;
import criteres.CritereSeuilAffinage;
import don.AxePartiel;
import don.Continue;
import don.ContinueAnalysee;
import don.ContinueArtificielleSurAxes;
import don.ContinueMoyenne;
import don.Cos2;
import don.Dimension;
import don.DonneeID;
import don.DonneeParse;
import don.Individu;
import don.Modalite;
import don.Nominale;
import don.NominaleArtificielleGroupe;
import don.ValeurTest;
import don.Variable;
import java.awt.Font;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import org.jfree.chart.annotations.XYIDAnnotation;
import outils.Constantes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Habilleur
implements Serializable {
    private static final long serialVersionUID = -6930776226529343758L;
    private DonneeParse m_don;
    private double m_seuil_affinage;
    private Vector<Variable> m_habillageDiscret;
    private Vector<Continue> m_habillageContinu;
    public static final int STYLE_BULLES = 0;
    public static final int STYLE_NUAGE = 1;
    private Vector<Integer> m_habillageStyleContinu;
    private Vector<HashMap<Continue, Double>> coeffZ;
    private Vector<HashMap<Continue, Double>> decZ;
    private Vector<Continue> m_habillageContinu_avant_desc;
    private Vector<Integer> m_habillageStyleContinu_avant_desc;
    private Vector<Variable> m_habillageDiscret_avant_desc;
    private Continue m_var_affinage;
    private ContinueAnalysee m_axeX;
    private ContinueAnalysee m_axeY;
    public static final int AXES_PARTIELS = 3;
    public static final int CONTINUES = 2;
    public static final int MODALITES = 1;
    public static final int INDIVIDUS = 0;
    private static final int NB_TYPES_DONNEES = 4;

    public Habilleur(DonneeParse don, ContinueAnalysee axeX, ContinueAnalysee axeY) {
        this.m_don = don;
        this.initTabCoeff();
        this.initTabHabillages();
        this.setAxeX(axeX);
        this.setAxeY(axeY);
        this.setAffinageDefaut();
    }

    private void initTabCoeff() {
        this.coeffZ = new Vector();
        this.coeffZ.setSize(4);
        this.decZ = new Vector();
        this.decZ.setSize(4);
        int i = 0;
        while (i < 4) {
            this.decZ.set(i, new HashMap());
            this.coeffZ.set(i, new HashMap());
            ++i;
        }
    }

    private void initTabHabillages() {
        this.m_habillageContinu = new Vector();
        this.m_habillageContinu.setSize(4);
        this.m_habillageStyleContinu = new Vector();
        this.m_habillageStyleContinu.setSize(4);
        int i = 0;
        while (i < 4) {
            this.m_habillageStyleContinu.setElementAt(1, i);
            ++i;
        }
        this.m_habillageDiscret = new Vector();
        this.m_habillageDiscret.setSize(4);
        this.m_habillageDiscret.setElementAt(new NominaleArtificielleGroupe(this.m_don.getGroupes().size()), 3);
        this.m_habillageContinu_avant_desc = (Vector)this.m_habillageContinu.clone();
        this.m_habillageStyleContinu_avant_desc = (Vector)this.m_habillageStyleContinu.clone();
        this.m_habillageDiscret_avant_desc = (Vector)this.m_habillageDiscret.clone();
    }

    private double getCoeffZ(Continue habillage, int type_donnees) {
        Double coeff = this.coeffZ.get(type_donnees).get(habillage);
        if (coeff == null) {
            this.setCoefficientsZ(habillage, type_donnees);
            coeff = this.coeffZ.get(type_donnees).get(habillage);
        }
        return coeff;
    }

    private double getDecZ(Continue habillage, int type_donnees) {
        Double dec = this.decZ.get(type_donnees).get(habillage);
        if (dec == null) {
            this.setCoefficientsZ(habillage, type_donnees);
            dec = this.decZ.get(type_donnees).get(habillage);
        }
        return dec;
    }

    private void setCoefficientsZ(Continue habillage, int type_donnees) {
        Double coeff;
        Double dec;
        Double min = habillage.getMin(this.getDonnees(type_donnees));
        Double max = habillage.getAmplitude(this.getDonnees(type_donnees)) + min;
        if (max > 0.0) {
            if (min < 0.0) {
                dec = 0.0;
                coeff = Math.max(max, -min.doubleValue());
            } else {
                dec = min;
                coeff = max - min;
            }
        } else {
            dec = min;
            coeff = max - min;
        }
        this.decZ.get(type_donnees).put(habillage, dec);
        this.coeffZ.get(type_donnees).put(habillage, coeff);
    }

    public boolean isHabillageCentre(int type_donnees) {
        Continue habillageContinu = this.getHabillageContinu(type_donnees);
        if (habillageContinu instanceof ValeurTest) {
            return true;
        }
        Double min = habillageContinu.getMin(this.getDonnees(type_donnees));
        Double max = habillageContinu.getAmplitude(this.getDonnees(type_donnees)) + min;
        return min < 0.0 && max > 0.0;
    }

    public boolean isHabillageCentre(DonneeID don) {
        return this.isHabillageCentre(this.getNumTypeHab(don));
    }

    private Vector<? extends DonneeID> getDonnees(int type_donnees) {
        if (type_donnees == 0) {
            return this.m_don.getIndividusMoyens();
        }
        if (type_donnees == 2) {
            return this.m_don.getVariablesMoyennes();
        }
        if (type_donnees == 1) {
            return this.m_don.getModalites();
        }
        if (type_donnees == 3) {
            return this.m_don.getAxesPartiels();
        }
        return null;
    }

    public Continue getHabillageContinu(int type_donnee) {
        return this.m_habillageContinu.get(type_donnee);
    }

    public Variable getHabillageDiscret(int type_donnee) {
        return this.m_habillageDiscret.get(type_donnee);
    }

    public Integer getHabillageStyleContinu(int type_donnee) {
        return this.m_habillageStyleContinu.get(type_donnee);
    }

    public Continue getHabillageContinu(DonneeID don) {
        int numTypeHab = this.getNumTypeHab(don);
        if (numTypeHab == -1) {
            return null;
        }
        return this.m_habillageContinu.get(numTypeHab);
    }

    public Variable getHabillageDiscret(DonneeID don) {
        int numTypeHab = this.getNumTypeHab(don);
        if (numTypeHab == -1) {
            return null;
        }
        return this.m_habillageDiscret.get(numTypeHab);
    }

    public Integer getHabillageStyleContinu(DonneeID don) {
        int numTypeHab = this.getNumTypeHab(don);
        if (numTypeHab == -1) {
            return null;
        }
        return this.m_habillageStyleContinu.get(numTypeHab);
    }

    private int getNumTypeHab(DonneeID don) {
        if (don instanceof Individu) {
            return 0;
        }
        if (don instanceof Modalite) {
            return 1;
        }
        if (don instanceof AxePartiel) {
            return 3;
        }
        if (don instanceof ContinueAnalysee) {
            return 2;
        }
        return -1;
    }

    public void supprimerHabillage(int type_donnees) {
        this.m_habillageContinu.setElementAt(null, type_donnees);
        this.m_habillageStyleContinu.setElementAt(1, type_donnees);
        this.m_habillageDiscret.setElementAt(null, type_donnees);
    }

    public void setDescription(Continue cont) {
        if (cont != null) {
            this.m_habillageContinu_avant_desc = (Vector)this.m_habillageContinu.clone();
            this.m_habillageStyleContinu_avant_desc = (Vector)this.m_habillageStyleContinu.clone();
            this.m_habillageDiscret_avant_desc = (Vector)this.m_habillageDiscret.clone();
            this.initTabHabillages();
            this.setHabillage(1, cont, 1);
        } else {
            this.m_habillageContinu = this.m_habillageContinu_avant_desc;
            this.m_habillageStyleContinu = this.m_habillageStyleContinu_avant_desc;
            this.m_habillageDiscret = this.m_habillageDiscret_avant_desc;
        }
    }

    public void setHabillage(int type_donnees, Continue cont, int style_habillage) {
        this.m_habillageContinu.setElementAt(cont, type_donnees);
        this.m_habillageStyleContinu.setElementAt(style_habillage, type_donnees);
    }

    public void setHabillage(int type_donnees, Variable habillage) {
        this.m_habillageDiscret.setElementAt(habillage, type_donnees);
    }

    public void setAxeX(ContinueAnalysee axeX) {
        this.m_axeX = axeX;
        if (axeX instanceof Dimension) {
            Dimension axeXDim = (Dimension)axeX;
            if (this.m_var_affinage instanceof ContinueArtificielleSurAxes) {
                ((ContinueArtificielleSurAxes)this.m_var_affinage).updateAxeX(axeXDim);
            }
            for (Continue var : this.m_habillageContinu) {
                if (var == null || !(var instanceof ContinueArtificielleSurAxes)) continue;
                ((ContinueArtificielleSurAxes)var).updateAxeX(axeXDim);
            }
        }
    }

    public ContinueAnalysee getAxeX() {
        return this.m_axeX;
    }

    public ContinueAnalysee getAxeY() {
        return this.m_axeY;
    }

    public void setAxeY(ContinueAnalysee axeY) {
        this.m_axeY = axeY;
        if (axeY instanceof Dimension) {
            Dimension axeYDim = (Dimension)axeY;
            if (this.m_var_affinage instanceof ContinueArtificielleSurAxes) {
                ((ContinueArtificielleSurAxes)this.m_var_affinage).updateAxeY(axeYDim);
            }
            for (Continue var : this.m_habillageContinu) {
                if (var == null || !(var instanceof ContinueArtificielleSurAxes)) continue;
                ((ContinueArtificielleSurAxes)var).updateAxeY(axeYDim);
            }
        }
    }

    public double getDecZ(Continue habillage, DonneeID id) {
        return this.getDecZ(habillage, this.getNumTypeHab(id));
    }

    public double getCoeffZ(Continue habillage, DonneeID id) {
        return this.getCoeffZ(habillage, this.getNumTypeHab(id));
    }

    public double getZ(DonneeID id, Continue habillage) {
        double valeurBrute = this.m_don.getValeur(id, habillage);
        return this.getZajuste(this.getNumTypeHab(id), habillage, valeurBrute);
    }

    private double getZajuste(int type, Continue habillage, double valeurBrute) {
        double val = valeurBrute;
        double test = (val - this.getDecZ(habillage, type)) / this.getCoeffZ(habillage, type) + 0.05;
        double valeur = test > 1.0 ? 1.0 : (test < 0.05 ? 0.05 : test);
        return valeur;
    }

    public Font getFont(DonneeID id, Continue habillage) {
        int taille;
        int style = Constantes.POLICE_ANNOTATIONS.getStyle();
        double coeff = this.getZ(id, habillage);
        if (habillage instanceof ValeurTest) {
            double moyen = this.getZajuste(this.getNumTypeHab(id), habillage, 2.0);
            taille = (int)((double)(Constantes.POLICE_ANNOTATIONS.getSize() - 6) / moyen * coeff + 6.0);
        } else {
            taille = (int)(coeff * 14.0 + 6.0);
        }
        if (taille > 20) {
            taille = 20;
        }
        return new Font(Constantes.POLICE_ANNOTATIONS.getName(), style, taille);
    }

    public void setFont(XYIDAnnotation annot, DonneeID id) {
        Continue habillage = this.getHabillageContinu(id);
        if (habillage != null && this.getHabillageStyleContinu(id) == 1) {
            annot.setFont(this.getFont(id, habillage));
        }
    }

    public Critere getCriterePositifNegatif() {
        return new CriterePositifNegatif(this);
    }

    public Critere getCritereSeuilAffinage() {
        return new CritereSeuilAffinage(this);
    }

    public boolean isHabillageNominalePossible() {
        return this.m_don.getNominales().size() > 0;
    }

    public boolean isHabillageContinuePossible() {
        return this.m_don.getVariablesMoyennes().size() > 0;
    }

    public Vector<ContinueMoyenne> getHabillageParContinuesPossible(int type) {
        if ((type == 1 || type == 0) && this.m_don.isVar()) {
            return this.m_don.getVariablesMoyennes();
        }
        return new Vector<ContinueMoyenne>();
    }

    public Variable getHabillageGroupe() {
        return new NominaleArtificielleGroupe(this.m_don.getGroupes().size());
    }

    public boolean isHabillageCos2Possible(int type) {
        return type != 3;
    }

    public boolean isHabillageContribPossible(int type) {
        return type == 3 || this.m_don.isVarActifNonOrtho() || this.m_don.isVarActifOrtho();
    }

    public boolean isHabillageIndividusParNominalePossible() {
        return this.m_don.isModActif() || this.m_don.isModIllus();
    }

    public Vector<Nominale> getHabillageParNominalePossible(int type) {
        if (type == 0 && this.m_don.isNominales()) {
            return this.m_don.getNominales();
        }
        return new Vector<Nominale>();
    }

    public boolean isHabillagePossible(int typeAff) {
        return typeAff != 2 && (this.m_don.getType() == DonneeParse.TypeAnalyse.MFA || this.m_don.getType() == DonneeParse.TypeAnalyse.DATAFRAME || typeAff == 0 || typeAff == 4);
    }

    public void setSeuilAffinage(double d) {
        this.m_seuil_affinage = d;
    }

    public double getSeuilAffinage() {
        return this.m_seuil_affinage;
    }

    public void setVarAffinage(Continue cont) {
        this.m_var_affinage = cont;
    }

    private void setAffinageDefaut() {
        if (this.getAxeX() instanceof Dimension && this.getAxeY() instanceof Dimension) {
            this.setVarAffinage(new Cos2((Dimension)this.getAxeX(), (Dimension)this.getAxeY()));
            this.setSeuilAffinage(0.0);
        }
    }

    public boolean isSousSeuilAffinage(DonneeID don) {
        return this.m_don.getValeur(don, this.m_var_affinage) < this.m_seuil_affinage;
    }
}

