% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_2t_equal.R
\name{power_2t_equal}
\alias{power_2t_equal}
\title{Calculate Power for Two-Sample Equal Variance T-Test}
\usage{
power_2t_equal(n = 100, d, sigsq, alpha = 0.05)
}
\arguments{
\item{n}{Numeric value specifying per-group sample size.}

\item{d}{Numeric value specifying true difference in group means. Should be
positive.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{alpha}{Numeric value specifying type-1 error rate.}
}
\value{
Numeric value.
}
\description{
Same idea as \code{\link[stats]{power.t.test}}. Less flexible, but faster.
}
\examples{
# Power to detect difference of 0.2 with 100 subjects per group and sigsq = 1
power_2t_equal(n = 100, d = 0.2, sigsq = 1)

}
