% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots_bars.R
\name{dots_bars}
\alias{dots_bars}
\title{Plot Points +/- Error Bars}
\usage{
dots_bars(y = NULL, bars = NULL, bars.lower = y - bars,
  bars.upper = y + bars, truth = NULL, group.labels = NULL,
  group.dividers = TRUE, subgroup.spacing = 1,
  subgroup.labels = NULL, subgroup.pch = NULL, subgroup.col = NULL,
  points.list = NULL, arrows.list = NULL, xaxis.list = NULL,
  yaxis.list = xaxis.list, abline.dividers.list = NULL,
  abline.truth.list = NULL, legend.list = NULL, ...)
}
\arguments{
\item{y}{Numeric vector of y-values for different groups, or numeric matrix 
where each column contains y-values for clustered subgroups within a group.}

\item{bars}{Numeric vector or matrix (matching whichever type \code{y} is) 
specifying the length of the error bar for each group/subgroup (i.e. distance 
from point to one end of error bar).}

\item{bars.lower}{Numeric vector or matrix (matching whichever type \code{y} 
is) specifying the position of the lower end of the error bar for each 
group/subgroup.}

\item{bars.upper}{Numeric vector or matrix (matching whichever type \code{y} 
is) specifying the position of the upper end of the error bar for each 
group/subgroup.}

\item{truth}{Numeric value specifying true value of parameter being 
estimated. If specified, a horizontal reference line is added to the plot.}

\item{group.labels}{Character vector of labels for the groups.}

\item{group.dividers}{Logical value for whether to add vertical lines 
distinguishing the groups.}

\item{subgroup.spacing}{Numeric value controlling the amount of spacing 
between subgroups, with values > 1 corresponding to more spacing.}

\item{subgroup.labels}{Character vector giving labels for the subgroups.}

\item{subgroup.pch}{Plotting symbol for different subgroups within each 
group.}

\item{subgroup.col}{Plotting color for different subgroups within each group.}

\item{points.list}{Optional list of inputs to pass to 
\code{\link[graphics]{points}}.}

\item{arrows.list}{Optional list of inputs to pass to 
\code{\link[graphics]{arrows}}.}

\item{xaxis.list}{Optional list of inputs to pass to 
\code{\link[graphics]{axis}} for x-axis.}

\item{yaxis.list}{Optional list of inputs to pass to 
\code{\link[graphics]{axis}} for y-axis.}

\item{abline.dividers.list}{Optional list of inputs to pass to 
\code{\link[graphics]{abline}} for group dividers. Only used if 
\code{group.dividers = TRUE}.}

\item{abline.truth.list}{Optional list of inputs to pass to 
\code{\link[graphics]{abline}} for horizontal line at true value of 
parameter. Only used if \code{truth} is specified.}

\item{legend.list}{Optional list of inputs to pass to 
\code{\link[graphics]{legend}}.}

\item{...}{Additional arguments to pass to \code{\link[graphics]{plot}} 
function.}
}
\value{
Plot showing points +/- error bars across groups/subgroups.
}
\description{
Creates plot showing user-specified points (e.g. means, medians, regression 
coefficients) along with user-specified error bars (e.g. standard deviations, 
min/max, 95\% confidence intervals).
}
\examples{
# Generate 100 values from normal distributions with different means, and 
# graph mean +/- standard deviation across groups 
dat <- cbind(rnorm(100, 2), rnorm(100, 2.5), rnorm(100, 1.75))
means <- apply(dat, 2, mean)
sds <- apply(dat, 2, sd)
fig1 <- dots_bars(y = means, bars = sds, main = "Mean +/- SD by Group",
                  ylab = "Mean +/- SD")
                  
# Simulate BMI values for males and females in 3 different age groups, and 
# graph mean +/- 95\% CI
sex <- as.factor(c(rep("Male", 300), rep("Female", 300)))
age <- as.factor(rep(c("Young", "Middle", "Old"), 2))
bmi <- c(rnorm(100, 25, 4), rnorm(100, 26, 4.25), rnorm(100, 27, 4.5),
         rnorm(100, 26.5, 4.5), rnorm(100, 27.25, 4.75), rnorm(100, 28, 5))
dat <- data.frame(sex = sex, age = age, bmi = bmi)
means <- tapply(dat$bmi, dat[, c("sex", "age")], mean)
ci.lower <- tapply(dat$bmi, dat[, c("sex", "age")],
                   function(x) t.test(x)$conf.int[1])
ci.upper <- tapply(dat$bmi, dat[, c("sex", "age")],
                   function(x) t.test(x)$conf.int[2])
fig2 <- dots_bars(y = means, bars.lower = ci.lower, bars.upper = ci.upper,
                  main = "BMI by Sex and Age",
                  ylab = "BMI (mean +/- CI)",
                  xlab = "Age group")

}
