% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{true_range_i}
\alias{true_range_i}
\title{True Range of Integer Values}
\usage{
true_range_i(x)
}
\arguments{
\item{x}{Integer vector or matrix.}
}
\value{
Integer value.
}
\description{
Defined as the difference between the maximum and the minimum. Equivalent to 
base R code \code{diff(range(x))}, but much faster.
}
\examples{
# In general, true_range_i is much faster than diff(range(x))
x <- rpois(1000, lambda = 5)
all.equal(diff(range(x)), true_range_i(x))
benchmark(diff(range(x)), true_range_i(x), replications = 5000)

}
