% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNonidentifiable.R
\name{findNonidentifiable}
\alias{findNonidentifiable}
\title{Nonidentifiable missing persons}
\usage{
findNonidentifiable(dvi)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}
}
\value{
A list with the following entries:
\itemize{
\item \code{nonidentifiable}: A character vector (possibly empty) with the names of
the nonidentifiable missing persons.
\item \code{dviReduced}: A reduced \code{dviData} object, where the nonidentifiable
individuals are removed from the list of missing persons. If there are no
\code{nonidentifiable}, this is just a copy of \code{dvi}.
\item \code{summary}: A data frame summarising the findings.
}
}
\description{
A missing person in a DVI case is \emph{nonidentifiable} if unrelated to all
(genotyped) reference individuals and all other missing persons in the
reference family. It is often wise to ignore such individuals in \code{\link[=jointDVI]{jointDVI()}}
and other analyses, to relieve the computational burden.
}
\details{
The implementation uses \code{ribd::kinship()} to identify individuals having
kinship coefficient 0 with all relevant individuals.
}
\examples{
# Example 1: No nonidentifiables in dataset `example1`
findNonidentifiable(example1)

# Example 2: Add nonidentifiable person "A"
amNew = example1$am[[1]] |>
  addSon(parents = c("NN", "A"))
missNew = c(example1$missing, "A")

dvi = dviData(pm = example1$pm, am = amNew, missing = missNew)
plotDVI(dvi, textAbove = c(A = "nonidentif."))

findNonidentifiable(dvi)

}
