% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findExcluded.R
\name{exclusionMatrix}
\alias{exclusionMatrix}
\title{Find the number of incompatible markers for each}
\usage{
exclusionMatrix(dvi, removeMut = TRUE)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{removeMut}{A logical. If TRUE (default), all mutations models are
stripped.}
}
\value{
An integer matrix with \code{length(pm)} columns and \code{length(am)} rows.
}
\description{
This function computes the number of exclusions, i.e., the number of
incompatible markers, for each pairwise comparison. By default, mutation
models are ignored. The main work is done by \code{\link[forrel:findExclusions]{forrel::findExclusions()}}.
}
\examples{

# Plane crash example
exclusionMatrix(planecrash)

# Inspect a particular pair: M3 vs V6
pm = planecrash$pm
am = planecrash$am
forrel::findExclusions(am, id = "M3", candidate = pm$V6)

# Plot one of the incompatible markers
plotDVI(planecrash, pm = 6, am = 3, marker ="D7S820")

}
