% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseLR.R
\name{pairwiseLR}
\alias{pairwiseLR}
\title{Pairwise LR matrix}
\usage{
pairwiseLR(
  pm,
  am,
  missing,
  pairings = NULL,
  ignoreSex = FALSE,
  limit = 0,
  nkeep = NULL,
  check = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{pm}{A list of singletons, the victims.}

\item{am}{A list of pedigrees. The reference families.}

\item{missing}{A character vector with names of missing persons.}

\item{pairings}{A list of possible pairings for each victim. If NULL, all
sex-consistent pairings are used.}

\item{ignoreSex}{A logical.}

\item{limit}{A nonnegative number controlling the \code{pairing} slot of the
output: Only pairings with LR greater or equal to \code{limit} are kept. If zero
(default), pairings with LR > 0 are kept.}

\item{nkeep}{An integer. No of pairings to keep, all if \code{NULL}.}

\item{check}{A logical, indicating if the input data should be checked for
consistency.}

\item{verbose}{A logical.}
}
\value{
A list with 3 elements:
\itemize{
\item \code{LRmatrix}: A matrix containing the pairwise LR values.
\item \code{LRlist}: A list of numerical vectors, containing the pairwise LRs in
list format.
\item \code{pairings}: A reduced version of the input \code{pairings}, keeping only
entries with corresponding LR >= \code{limit}. For the default case \code{limit = 0}
a strict inequality is used, i.e., LR > 0.
}
}
\description{
For a given DVI problem, compute the matrix consisting of pairwise likelihood
ratios \eqn{LR_{i,j}} comparing \eqn{V_i = M_j} to the null. The output may
be reduced by specifying arguments \code{limit} or \code{nkeep}.
}
\examples{

pm = example1$pm
am = example1$am
missing = example1$missing

pairwiseLR(pm, am, missing)

}
