% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{read_sql_duckdb}
\alias{read_sql_duckdb}
\title{Return SQL query as duckdb_tibble}
\usage{
read_sql_duckdb(
  sql,
  ...,
  prudence = c("thrifty", "lavish", "stingy"),
  con = NULL
)
}
\arguments{
\item{sql}{The SQL to run.}

\item{...}{These dots are for future extensions and must be empty.}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"thrifty"}: up to a maximum size of 1 million cells,
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never.
}

The default is \code{"thrifty"} for the ingestion functions,
and may be different for other functions.
See \code{vignette("prudence")} for more information.}

\item{con}{The connection, defaults to the default connection.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Runs a query and returns it as a duckplyr frame.
}
\details{
Using data frames from the calling environment is not supported yet,
see \url{https://github.com/duckdb/duckdb-r/issues/645} for details.
}
\examples{
read_sql_duckdb("FROM duckdb_settings()")
}
\seealso{
\code{\link[=db_exec]{db_exec()}}
}
