% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_join.R
\name{spatial_join}
\alias{spatial_join}
\title{spatial_join}
\usage{
spatial_join(
  x,
  y,
  by = c("st_intersects", "st_within", "st_dwithin", "st_touches", "st_contains",
    "st_containsproperly", "st_covers", "st_overlaps", "st_crosses", "st_equals",
    "st_disjoint"),
  args = "",
  join = "left",
  tblname = tmp_tbl_name(),
  conn = cached_connection()
)
}
\arguments{
\item{x}{a duckdb table with a spatial geometry column called "geom"}

\item{y}{a duckdb table with a spatial geometry column called "geom"}

\item{by}{A spatial join function, see details.}

\item{args}{additional arguments to join function (e.g. distance for st_dwithin)}

\item{join}{JOIN type (left, right, inner, full)}

\item{tblname}{name for the temporary view}

\item{conn}{the duckdb connection (imputed by duckdbfs by default,
must be shared across both tables)}
}
\value{
a (lazy) view of the resulting table. Users can continue to operate
on using dplyr operations and call to_st() to collect this as an sf object.
}
\description{
spatial_join
}
\details{
Possible \href{https://postgis.net/workshops/postgis-intro/spatial_relationships.html}{spatial joins} include:\tabular{ll}{
   Function \tab Description \cr
   st_intersects \tab Geometry A intersects with geometry B \cr
   st_disjoint \tab The complement of intersects \cr
   st_within \tab Geometry A is within geometry B (complement of contains) \cr
   st_dwithin \tab Geometries are within a specified distance, expressed in the same units as the coordinate reference system. \cr
   st_touches \tab Two polygons touch if the that have at least one point in common, even if their interiors do not touch. \cr
   st_contains \tab Geometry A entirely contains to geometry B. (complement of within) \cr
   st_containsproperly \tab stricter version of \code{st_contains} (boundary counts as external) \cr
   st_covers \tab geometry B is inside or on boundary of A. (A polygon covers a point on its boundary but does not contain it.) \cr
   st_overlaps \tab geometry A intersects but does not completely contain geometry B \cr
   st_equals \tab geometry A is equal to geometry B \cr
   st_crosses \tab Lines or points in geometry A cross geometry B. \cr
}


All though SQL is not case sensitive, this function expects only
lower case names for "by" functions.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# note we can read in remote data in a variety of vector formats:
countries <-
paste0("/vsicurl/",
       "https://github.com/cboettig/duckdbfs/",
       "raw/spatial-read/inst/extdata/world.gpkg") |>
open_dataset(format = "sf")

cities <-
 paste0("/vsicurl/https://github.com/cboettig/duckdbfs/raw/",
        "spatial-read/inst/extdata/metro.fgb") |>
 open_dataset(format = "sf")

countries |>
  dplyr::filter(iso_a3 == "AUS") |>
  spatial_join(cities)
\dontshow{\}) # examplesIf}
}
