% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.spls.print.R
\name{d.spls.print}
\alias{d.spls.print}
\title{Print function for Dual-SPLS models}
\usage{
d.spls.print(mod.dspls,ncomp)
}
\arguments{
\item{mod.dspls}{is a fitted Dual-SPLS object.}

\item{ncomp}{a positive integer of the number of Dual-SPLS components.}
}
\value{
no return value
}
\description{
The function \code{d.spls.print} pisplays the values of a Dual-SPLS regression parameters of sparsity and the number of variables
shrinked to zero for a specified number of components.
}
\examples{
### load dual.spls library
library(dual.spls)
### constructing the simulated example
n <- 100
p <- 50
nondes <- 20
sigmaondes <- 0.5
data=d.spls.simulate(n=n,p=p,nondes=nondes,sigmaondes=sigmaondes)

X <- data$X
y <- data$y

#fitting the Dual-SPLS lasso model

ncomplasso <- d.spls.cv(X=X,Y=y,ncomp=10,dspls="lasso",ppnu=0.9,nrepcv=20,pctcv=75)
mod.dspls.lasso <- d.spls.lasso(X=X,y=y,ncp=ncomplasso,ppnu=0.9,verbose=TRUE)

d.spls.print(mod.dspls.lasso,ncomplasso)
}
\author{
Louna Alsouki François Wahl
}
