% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CENTROIDS-sdtw-cent.R
\name{sdtw_cent}
\alias{sdtw_cent}
\title{Centroid calculation based on soft-DTW}
\usage{
sdtw_cent(
  series,
  centroid = NULL,
  gamma = 0.01,
  weights = rep(1, length(series)),
  ...,
  error.check = TRUE,
  opts = list(algorithm = "NLOPT_LD_LBFGS", maxeval = 20L)
)
}
\arguments{
\item{series}{A matrix or data frame where each row is a time series, or a list where each
element is a time series. Multivariate series should be provided as a list of matrices where
time spans the rows and the variables span the columns of each matrix.}

\item{centroid}{Optionally, a time series to use as reference. Defaults to a random series of
\code{series} if \code{NULL}. For multivariate series, this should be a matrix with the same
characteristics as the matrices in \code{series}.}

\item{gamma}{Positive regularization parameter, with lower values resulting in less smoothing.}

\item{weights}{A vector of weights for each element of \code{series}.}

\item{...}{Further arguments for the optimization backend (except \code{opts} for \code{nloptr}, \code{control}
for \code{optim}, and \code{...} for both).}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}

\item{opts}{List of options to pass to \code{nloptr} or \code{\link[stats:optim]{stats::optim()}}'s \code{control}. The defaults in
the function's formals are for \code{nloptr}, but the value will be adjusted for \code{optim} if needed.}
}
\value{
The resulting centroid, with the optimization results as attributes (except for the
returned centroid).
}
\description{
Soft-DTW centroid function as proposed in Cuturi and Blondel (2017).
}
\details{
This function can delegate the optimization to the \pkg{nloptr} package. For that to happen, you
must load it with either \code{\link[base:library]{base::library()}} or \code{\link[base:ns-load]{base::loadNamespace()}}. If the aforementioned is
not fulfilled, the function will delegate to \code{\link[stats:optim]{stats::optim()}}.
}
\section{Parallel Computing}{


Please note that running tasks in parallel does \strong{not} guarantee faster computations. The
overhead introduced is sometimes too large, and it's better to run tasks sequentially.

This function uses the \code{\link[RcppParallel:RcppParallel-package]{RcppParallel}} package
for parallelization. It uses all available threads by default (see
\code{\link[RcppParallel:defaultNumThreads]{RcppParallel::defaultNumThreads()}}), but this can
be changed by the user with
\code{\link[RcppParallel:setThreadOptions]{RcppParallel::setThreadOptions()}}.

An exception to the above is when this function is called within a
\code{\link[foreach:foreach]{foreach}} parallel loop \strong{made by dtwclust}. If the parallel
workers do not have the number of threads explicitly specified, this function will default to 1
thread per worker. See the parallelization vignette for more information
(\code{browseVignettes("dtwclust")}).



For unknown reasons, this function has returned different results (in the order of 1e-6) when
using multi-threading in x64 Windows installations in comparison to other environments (using
nloptr v1.0.4). Consider limiting the number of threads if you run into reproducibility
problems.
}

\references{
Cuturi, M., & Blondel, M. (2017). Soft-DTW: a Differentiable Loss Function for Time-Series. arXiv
preprint arXiv:1703.01541.
}
