% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClassification.R
\name{plotClassification}
\alias{plotClassification}
\title{Plotting subintervals classification}
\usage{
plotClassification(
  x,
  timeseries.labels = NULL,
  patterns.labels = NULL,
  attr,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwMatches}}.}

\item{timeseries.labels}{The label or index of the time series.
Default is 1.}

\item{patterns.labels}{A vector with labels of the patterns. If not 
declared the function will plot one alignment for each pattern.}

\item{attr}{An \link[base]{integer} vector or \link[base]{character} vector 
indicating the attribute for plotting. If not declared the function will plot 
all attributes.}

\item{...}{Additional arguments passed to \code{\link[dtwSat]{twdtwClassify}}.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting the classification of each 
subinterval of the time series based on TWDTW analysis.
}
\examples{
log_fun = logisticWeight(-0.1, 100)
ts = twdtwTimeSeries(MOD13Q1.ts.list)
patt = twdtwTimeSeries(MOD13Q1.patterns.list)
mat1 = twdtwApply(x=ts, y=patt, weight.fun=log_fun, keep=TRUE, legacy=TRUE)

# Classify interval
from = as.Date("2007-09-01")
to = as.Date("2013-09-01")
by = "6 month"
gp = plotClassification(x=mat1, from=from, to=to, by=by, overlap=.5)
gp


}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{twdtwClassify}}, 
\code{\link[dtwSat]{plotAlignments}}, 
\code{\link[dtwSat]{plotPaths}},
\code{\link[dtwSat]{plotMatches}}, and
\code{\link[dtwSat]{plotCostMatrix}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
