% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot-dtwSat.R
\docType{methods}
\name{plot,dtwSat-method}
\alias{plot,dtwSat-method}
\title{Plotting dtwSat objects}
\usage{
\S4method{plot}{dtwSat}(x, type = "path", ...)
}
\arguments{
\item{x}{A \code{\link[dtwSat]{dtwSat-class}} object}

\item{type}{A character for the plot type, ''path'', ''alignment'', or
''classify''. Default is "path"}

\item{...}{additional arguments passed to plotting functions
\code{\link[dtwSat]{plotPath}}, \code{\link[dtwSat]{plotAlignment}}, and
\code{\link[dtwSat]{plotClassify}}}
}
\value{
object of class \link[ggplot2]{ggplot}
}
\description{
Methods for plotting the results of the
Time-Weighted DTW analysis
}
\examples{
names(query.list)
alig = dtwSat(query.list[["Soybean"]], template, weight = "logistic",
       alpha = 0.1, beta = 100, n.alignments = 4, keep = TRUE)

## Plot path
gp1 = plot(alig, type="path", normalize=TRUE, show.dist = TRUE)
gp1

## Plot alignment
gp2 = plot(alig, type="alignment", n=1, attr="evi", shift=0.5)
gp2

## Plot classification
gp3 = plot(alig, type="classify", attr="evi",
         from=as.Date("2009-09-01"),  to=as.Date("2013-09-01"),
         by = "6 month", normalized=TRUE, overlap=.7)
gp3
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat-class}}, \code{\link[dtwSat]{dtwSat}},
\code{\link[dtwSat]{plotPath}}, \code{\link[dtwSat]{plotAlignment}}, and
\code{\link[dtwSat]{plotClassify}}
}

